# ColumnFormatter.py - Data handling routines developed by Optibrium for integration of CDD Vault with StarDrop software
# Use of this code is subject to the terms of the StarDrop License Agreement and use, copying or redistribution of this file for use by other persons or organisations is prohibited
# Copyright(C) Optibrium Ltd 2016
# stardrop-support@optibrium.com
#

"""Module to identify columns to be used as erros when constructing a StarDrop data set from CDD Vault data"""

def formatColumns(columns, deviation_term=[" Standard Deviation "]):
	"""Identify the error columns and relate them to the values columns. This assumes that Standard Deviation and Count are standard naminbgs, and will appear next to the data to which thewy relate
	@param: columns: A list of ColumnInfo objects with no error columns specified
	@returns: A new list of ColumnInfo objects with errors associated wit the correct values
	"""
	def isStandardDeviation(column,test):
		for term in deviation_term:
			index = test.find(term)
			if index != -1:
				break
		return (index != -1)
	def isCount(column,test):
		return test.endswith(" Count")
	lastColumn = None
	formattedColumns = []
	for i,column in enumerate(columns):
		if lastColumn:
			if isStandardDeviation(lastColumn.name, column.name) == True:
				lastColumn.errorIndex = i
			elif isCount(lastColumn.name, column.name) == True:
				pass
			else:
				formattedColumns.append(column)
		else:
			formattedColumns.append(column)
		lastColumn = formattedColumns[-1]
	return formattedColumns